<?php
/**
 * ISLMS - 開班管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$offeringModel = new OfferingModel();
$courseModel = new CourseModel();
$userModel = new UserModel();
$sectionModel = new SectionModel();
$levelModel = new LevelModel();

$action = $_GET['action'] ?? 'list';

// AJAX 處理
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        
        if ($ajaxAction === 'auto_assign' && $auth->hasRole(['admin', 'staff'])) {
            $id = (int) ($_POST['id'] ?? 0);
            $maxPerSection = (int) ($_POST['max_per_section'] ?? 12);
            
            try {
                $result = $sectionModel->autoAssign($id, $maxPerSection);
                echo json_encode(['success' => true, 'message' => $result['message'], 'data' => $result]);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
    }
    exit;
}

switch ($action) {
    case 'create':
    case 'edit':
        if (!$auth->hasRole(['admin', 'staff'])) {
            setFlash('error', '權限不足');
            header('Location: ' . APP_URL . '/offerings.php');
            exit;
        }
        
        $offering = null;
        $id = (int) ($_GET['id'] ?? 0);
        
        if ($action === 'edit' && $id) {
            $offering = $offeringModel->getWithDetails($id);
            if (!$offering) {
                setFlash('error', '開班資料不存在');
                header('Location: ' . APP_URL . '/offerings.php');
                exit;
            }
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'course_id' => (int) ($_POST['course_id'] ?? 0),
                'semester' => trim($_POST['semester'] ?? ''),
                'teacher_id' => (int) ($_POST['teacher_id'] ?? 0) ?: null,
                'classroom' => trim($_POST['classroom'] ?? ''),
                'start_date' => $_POST['start_date'] ?? '',
                'end_date' => $_POST['end_date'] ?? '',
                'class_time' => trim($_POST['class_time'] ?? ''),
                'schedule' => trim($_POST['schedule'] ?? ''),
                'hours_per_week' => (float) ($_POST['hours_per_week'] ?? 0) ?: null,
                'total_hours' => (float) ($_POST['total_hours'] ?? 0) ?: null,
                'max_students_per_section' => (int) ($_POST['max_students_per_section'] ?? 12),
                'offering_status' => $_POST['offering_status'] ?? 'draft',
                'note' => trim($_POST['note'] ?? ''),
                'updated_by' => $auth->user()['account']
            ];
            
            $errors = [];
            if (!$data['course_id']) $errors[] = '請選擇課程';
            if (empty($data['semester'])) $errors[] = '學期為必填';
            if (empty($data['start_date'])) $errors[] = '開課日期為必填';
            if (empty($data['end_date'])) $errors[] = '結課日期為必填';
            
            if (empty($errors)) {
                if ($action === 'edit') {
                    $offeringModel->update($id, $data);
                    setFlash('success', '開班資料已更新');
                } else {
                    $offeringModel->create($data);
                    setFlash('success', '開班已新增');
                }
                header('Location: ' . APP_URL . '/offerings.php');
                exit;
            }
        }
        
        $courses = $courseModel->getActive();
        $teachers = $userModel->getTeachers();
        
        $pageTitle = ($action === 'edit' ? '編輯' : '新增') . '開班 - ' . APP_NAME;
        $breadcrumb = [
            ['title' => '開班管理', 'url' => url('offerings.php')],
            ['title' => $action === 'edit' ? '編輯開班' : '新增開班', 'active' => true]
        ];
        
        ob_start();
        include VIEW_PATH . '/offerings/form.php';
        $content = ob_get_clean();
        break;
        
    case 'view':
        $id = (int) ($_GET['id'] ?? 0);
        $offering = $offeringModel->getWithDetails($id);
        
        if (!$offering) {
            setFlash('error', '開班資料不存在');
            header('Location: ' . APP_URL . '/offerings.php');
            exit;
        }
        
        $sections = $sectionModel->getByOffering($id);
        
        $pageTitle = $offering['course_name'] . ' - ' . APP_NAME;
        $breadcrumb = [
            ['title' => '開班管理', 'url' => url('offerings.php')],
            ['title' => $offering['course_name'], 'active' => true]
        ];
        
        ob_start();
        include VIEW_PATH . '/offerings/view.php';
        $content = ob_get_clean();
        break;
        
    default:
        $semester = $_GET['semester'] ?? '';
        $status = $_GET['status'] ?? '';
        $teacherId = $auth->isTeacher() ? $auth->id() : null;
        $offerings = $offeringModel->getAllWithDetails($semester, $status, $teacherId);
        $semesters = $offeringModel->getSemesters();
        
        $pageTitle = '開班管理 - ' . APP_NAME;
        $breadcrumb = [['title' => '開班管理', 'active' => true]];
        
        ob_start();
        include VIEW_PATH . '/offerings/index.php';
        $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
