<?php
/**
 * UserModel - 使用者模型
 */
class UserModel extends Model {
    protected $table = 'users';
    protected $primaryKey = 'user_id';
    protected $fillable = [
        'account', 'password_hash', 'role', 'name', 'name_en',
        'email', 'phone', 'status', 'updated_by'
    ];
    
    public function findByAccount($account) {
        return $this->findBy('account', $account);
    }
    
    public function getTeachers() {
        return $this->where("role = 'teacher' AND status = 1", [], 'name ASC');
    }
    
    public function createUser($data) {
        if (isset($data['password'])) {
            $data['password_hash'] = password_hash($data['password'], PASSWORD_DEFAULT);
            unset($data['password']);
        }
        return $this->create($data);
    }
    
    public function updateUser($id, $data) {
        if (isset($data['password']) && !empty($data['password'])) {
            $data['password_hash'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }
        unset($data['password']);
        return $this->update($id, $data);
    }
    
    public function changePassword($id, $newPassword) {
        return $this->update($id, [
            'password_hash' => password_hash($newPassword, PASSWORD_DEFAULT)
        ]);
    }
    
    public function verifyPassword($id, $password) {
        $user = $this->find($id);
        return $user && password_verify($password, $user['password_hash']);
    }
    
    public function search($keyword, $role = null) {
        $conditions = "(account LIKE ? OR name LIKE ? OR email LIKE ?)";
        $params = ["%{$keyword}%", "%{$keyword}%", "%{$keyword}%"];
        
        if ($role) {
            $conditions .= " AND role = ?";
            $params[] = $role;
        }
        
        return $this->where($conditions, $params, 'name ASC');
    }
}
