<?php
/**
 * ISLMS - 儀表板
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

// 載入模型
$studentModel = new StudentModel();
$offeringModel = new OfferingModel();
$sectionModel = new SectionModel();

// 統計數據
$stats = [
    'total_students' => $studentModel->count('status = 1'),
    'active_offerings' => $offeringModel->count("offering_status = 'active'"),
    'total_sections' => $sectionModel->count("section_status = 'active'"),
    'total_enrollments' => (new EnrollmentModel())->count("enrollment_status = 'active'")
];

// 進行中的課程
$activeOfferings = $offeringModel->getAllWithDetails('', 'active');

// 學生程度分布
$levelStats = $studentModel->getStatsByLevel();

// 如果是老師，取得其班級
$teacherSections = [];
if ($auth->isTeacher()) {
    $teacherSections = $sectionModel->getByTeacher($auth->id());
}

// 頁面資料
$pageTitle = '儀表板 - ' . APP_NAME;
$layout = 'main';

// 渲染視圖
ob_start();
include VIEW_PATH . '/dashboard/index.php';
$content = ob_get_clean();

include VIEW_PATH . '/layouts/main.php';
