<?php
/**
 * ISLMS - 課程設定
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check() || !$auth->isAdmin()) {
    setFlash('error', '權限不足');
    header('Location: ' . APP_URL . '/dashboard.php');
    exit;
}

$courseModel = new CourseModel();
$levelModel = new LevelModel();
$action = $_GET['action'] ?? 'list';

// AJAX
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        if ($ajaxAction === 'delete') {
            $id = (int) ($_POST['id'] ?? 0);
            $courseModel->update($id, ['status' => 0]);
            echo json_encode(['success' => true]);
            exit;
        }
    }
    exit;
}

switch ($action) {
    case 'create':
    case 'edit':
        $course = null;
        $id = (int) ($_GET['id'] ?? 0);
        if ($action === 'edit' && $id) {
            $course = $courseModel->find($id);
            if (!$course) {
                setFlash('error', '課程不存在');
                header('Location: ' . APP_URL . '/courses.php');
                exit;
            }
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'course_code' => trim($_POST['course_code'] ?? ''),
                'course_name' => trim($_POST['course_name'] ?? ''),
                'course_name_en' => trim($_POST['course_name_en'] ?? ''),
                'level_code' => $_POST['level_code'] ?? '',
                'textbook' => trim($_POST['textbook'] ?? ''),
                'description' => trim($_POST['description'] ?? ''),
                'status' => 1,
                'updated_by' => $auth->user()['account']
            ];
            
            $errors = [];
            if (empty($data['course_code'])) $errors[] = '課程代碼為必填';
            if (empty($data['course_name'])) $errors[] = '課程名稱為必填';
            
            if (empty($errors)) {
                if ($action === 'edit') {
                    $courseModel->update($id, $data);
                    setFlash('success', '課程已更新');
                } else {
                    $courseModel->create($data);
                    setFlash('success', '課程已新增');
                }
                header('Location: ' . APP_URL . '/courses.php');
                exit;
            }
        }
        
        $levels = $levelModel->getActive();
        $pageTitle = ($action === 'edit' ? '編輯' : '新增') . '課程 - ' . APP_NAME;
        $breadcrumb = [['title' => '課程設定', 'url' => url('courses.php')], ['title' => $action === 'edit' ? '編輯課程' : '新增課程', 'active' => true]];
        
        ob_start();
        ?>
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0"><?= $action === 'edit' ? '編輯課程' : '新增課程' ?></h1>
        </div>
        <?php if (!empty($errors)): ?>
        <div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-body">
                <form method="post">
                    <?= csrfField() ?>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">課程代碼 <span class="text-danger">*</span></label>
                            <input type="text" name="course_code" class="form-control" required value="<?= e($course['course_code'] ?? $_POST['course_code'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">課程名稱 <span class="text-danger">*</span></label>
                            <input type="text" name="course_name" class="form-control" required value="<?= e($course['course_name'] ?? $_POST['course_name'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">英文名稱</label>
                            <input type="text" name="course_name_en" class="form-control" value="<?= e($course['course_name_en'] ?? $_POST['course_name_en'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">程度</label>
                            <select name="level_code" class="form-select">
                                <option value="">請選擇</option>
                                <?php foreach ($levels as $l): ?>
                                <option value="<?= e($l['level_code']) ?>" <?= ($course['level_code'] ?? $_POST['level_code'] ?? '') === $l['level_code'] ? 'selected' : '' ?>><?= e($l['level_name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-8 mb-3">
                            <label class="form-label">教材</label>
                            <input type="text" name="textbook" class="form-control" value="<?= e($course['textbook'] ?? $_POST['textbook'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">說明</label>
                        <textarea name="description" class="form-control" rows="3"><?= e($course['description'] ?? $_POST['description'] ?? '') ?></textarea>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                        <a href="<?= url('courses.php') ?>" class="btn btn-secondary">取消</a>
                    </div>
                </form>
            </div>
        </div>
        <?php
        $content = ob_get_clean();
        break;
        
    default:
        $courses = $courseModel->search();
        $pageTitle = '課程設定 - ' . APP_NAME;
        $breadcrumb = [['title' => '課程設定', 'active' => true]];
        
        ob_start();
        ?>
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">課程設定</h1>
            <a href="<?= url('courses.php?action=create') ?>" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>新增課程</a>
        </div>
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover data-table mb-0">
                        <thead>
                            <tr>
                                <th>課程代碼</th>
                                <th>課程名稱</th>
                                <th>程度</th>
                                <th>教材</th>
                                <th width="100">操作</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($courses as $c): ?>
                            <tr>
                                <td><?= e($c['course_code']) ?></td>
                                <td><?= e($c['course_name']) ?><?= $c['course_name_en'] ? '<br><small class="text-muted">' . e($c['course_name_en']) . '</small>' : '' ?></td>
                                <td><span class="badge bg-info"><?= e($c['level_code'] ?: '-') ?></span></td>
                                <td><small><?= e($c['textbook'] ?: '-') ?></small></td>
                                <td>
                                    <a href="<?= url('courses.php?action=edit&id=' . $c['course_id']) ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-pencil"></i></a>
                                    <button class="btn btn-sm btn-outline-danger" onclick="deleteCourse(<?= $c['course_id'] ?>)"><i class="bi bi-trash"></i></button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <script>
        function deleteCourse(id) {
            if (!confirm('確定要刪除此課程嗎？')) return;
            $.post('<?= url('courses.php') ?>', {action: 'delete', id: id, <?= CSRF_TOKEN_NAME ?>: csrfToken}, function(res) {
                if (res.success) location.reload();
            });
        }
        </script>
        <?php
        $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
