<?php
/**
 * ISLMS - 國際生學習管理系統 配置檔
 * International Student Learning Management System
 */

// 錯誤報告
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// 時區設定
date_default_timezone_set('Asia/Taipei');

// 資料庫設定
define('DB_HOST', 'localhost');
define('DB_NAME', 'islms');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// 應用程式設定
define('APP_NAME', '國際生學習管理系統');
define('APP_NAME_EN', 'International Student Learning Management System');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/islms');

// 路徑設定
define('ROOT_PATH', dirname(__DIR__));
define('CONFIG_PATH', ROOT_PATH . '/config');
define('CORE_PATH', ROOT_PATH . '/core');
define('CONTROLLER_PATH', ROOT_PATH . '/controllers');
define('MODEL_PATH', ROOT_PATH . '/models');
define('VIEW_PATH', ROOT_PATH . '/views');
define('PUBLIC_PATH', ROOT_PATH . '/public');
define('UPLOAD_PATH', PUBLIC_PATH . '/uploads');

// Session 設定
define('SESSION_NAME', 'ISLMS_SESSION');
define('SESSION_LIFETIME', 7200); // 2小時

// 分頁設定
define('ITEMS_PER_PAGE', 20);

// 上傳設定
define('MAX_UPLOAD_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_EXTENSIONS', ['xlsx', 'xls', 'csv']);

// 郵件設定 (從資料庫讀取)
define('MAIL_FROM_NAME', '華語教學中心');

// 系統預設值
define('DEFAULT_MAX_STUDENTS_PER_SECTION', 12);
define('DEFAULT_PASSING_GRADE', 60);

// CSRF Token 名稱
define('CSRF_TOKEN_NAME', '_csrf_token');

// 自動載入
spl_autoload_register(function ($class) {
    $paths = [CORE_PATH, CONTROLLER_PATH, MODEL_PATH];
    foreach ($paths as $path) {
        $file = $path . '/' . $class . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});

// 載入核心檔案
require_once CORE_PATH . '/Database.php';
require_once CORE_PATH . '/Controller.php';
require_once CORE_PATH . '/Model.php';
require_once CORE_PATH . '/Auth.php';
require_once CORE_PATH . '/Helper.php';
