<?php
/**
 * ISLMS - 點名管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$attendanceModel = new AttendanceModel();
$sectionModel = new SectionModel();

$sectionId = (int) ($_GET['section_id'] ?? 0);
$classDate = $_GET['date'] ?? date('Y-m-d');

// AJAX 處理
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        
        if ($ajaxAction === 'save') {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $classDate = $_POST['class_date'] ?? '';
            $attendance = $_POST['attendance'] ?? [];
            
            // 權限檢查
            if ($auth->isTeacher()) {
                $teacherSections = $sectionModel->getByTeacher($auth->id());
                if (!in_array($sectionId, array_column($teacherSections, 'section_id'))) {
                    echo json_encode(['success' => false, 'message' => '權限不足']);
                    exit;
                }
            }
            
            try {
                $attendanceModel->saveAttendance($sectionId, $classDate, $attendance, $auth->id());
                echo json_encode(['success' => true, 'message' => '點名已儲存']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
        
        if ($ajaxAction === 'lock' && $auth->hasRole(['admin', 'staff'])) {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $classDate = $_POST['class_date'] ?? '';
            $attendanceModel->lockDate($sectionId, $classDate, $auth->id());
            echo json_encode(['success' => true, 'message' => '已鎖定']);
            exit;
        }
        
        if ($ajaxAction === 'unlock' && $auth->hasRole(['admin', 'staff'])) {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $classDate = $_POST['class_date'] ?? '';
            $attendanceModel->unlockDate($sectionId, $classDate);
            echo json_encode(['success' => true, 'message' => '已解鎖']);
            exit;
        }
        
        if ($ajaxAction === 'init') {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $classDate = $_POST['class_date'] ?? '';
            
            if ($auth->isTeacher()) {
                $teacherSections = $sectionModel->getByTeacher($auth->id());
                if (!in_array($sectionId, array_column($teacherSections, 'section_id'))) {
                    echo json_encode(['success' => false, 'message' => '權限不足']);
                    exit;
                }
            }
            
            $count = $attendanceModel->initializeAttendance($sectionId, $classDate, $auth->id());
            echo json_encode(['success' => true, 'message' => "已建立 {$count} 筆點名記錄"]);
            exit;
        }
    }
    exit;
}

// 如果有指定班級
if ($sectionId) {
    $section = $sectionModel->getWithDetails($sectionId);
    
    if (!$section) {
        setFlash('error', '班級不存在');
        header('Location: ' . APP_URL . '/attendance.php');
        exit;
    }
    
    // 教師權限檢查
    if ($auth->isTeacher()) {
        $teacherSections = $sectionModel->getByTeacher($auth->id());
        if (!in_array($sectionId, array_column($teacherSections, 'section_id'))) {
            setFlash('error', '您沒有權限操作此班級');
            header('Location: ' . APP_URL . '/attendance.php');
            exit;
        }
    }
    
    // 取得點名記錄
    $records = $attendanceModel->getByDate($sectionId, $classDate);
    $isLocked = $attendanceModel->isDateLocked($sectionId, $classDate);
    $dates = $attendanceModel->getDates($sectionId);
    $students = $sectionModel->getStudents($sectionId);
    
    // 將記錄轉為以學生ID為key的陣列
    $recordMap = [];
    foreach ($records as $r) {
        $recordMap[$r['student_id']] = $r;
    }
    
    $pageTitle = '點名 - ' . $section['section_name'] . ' - ' . APP_NAME;
    $breadcrumb = [
        ['title' => '點名管理', 'url' => url('attendance.php')],
        ['title' => $section['course_name'] . ' ' . $section['section_name'], 'active' => true]
    ];
    
    ob_start();
    include VIEW_PATH . '/attendance/sheet.php';
    $content = ob_get_clean();
} else {
    // 班級選擇頁面
    if ($auth->isTeacher()) {
        $sections = $sectionModel->getByTeacher($auth->id());
    } else {
        $sql = "SELECT s.*, o.semester, c.course_name, c.level_code, u.name as teacher_name
                FROM sections s
                LEFT JOIN offerings o ON s.offering_id = o.offering_id
                LEFT JOIN courses c ON o.course_id = c.course_id
                LEFT JOIN users u ON COALESCE(s.teacher_id, o.teacher_id) = u.user_id
                WHERE o.offering_status = 'active' AND s.section_status = 'active'
                ORDER BY c.course_name, s.section_name";
        $sections = Database::getInstance()->fetchAll($sql);
    }
    
    $pageTitle = '點名管理 - ' . APP_NAME;
    $breadcrumb = [['title' => '點名管理', 'active' => true]];
    
    ob_start();
    include VIEW_PATH . '/attendance/index.php';
    $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
