# 國際生學習管理系統 (ISLMS)
## International Student Learning Management System

### 系統簡介

本系統為華語教學中心設計的國際生學習管理系統，支援學位生與交換生的華語課程管理，包含開班、選課、點名、成績等完整功能。

### 技術架構

- **後端**: PHP 8.1+
- **資料庫**: MySQL 8.0+
- **前端**: Bootstrap 5.3 + jQuery 3.7
- **架構**: MVC 模式

### 功能特色

#### 📚 開班管理
- 依學期建立課程開班
- 設定上課時間、教室、授課教師
- 自動編班功能（依程度分配學生）

#### 👥 學生管理
- 學生資料維護
- Excel 批次匯入
- 8 種中文程度分級 (BEG ~ ADV1)

#### 📋 班級管理
- 班級名單管理
- 調班、退選、加選功能
- 異動記錄追蹤

#### ✅ 點名管理
- 線上點名作業
- 6 種出席狀態 (出席/遲到/缺席/請假/公假/病假)
- 點名鎖定功能

#### 📊 成績管理
- 自訂評分項目與權重
- 線上成績輸入
- 自動計算總分與等第

#### 📄 成績單
- 線上產生成績單
- 列印功能

#### 📈 統計報表
- 出席統計報表
- 成績統計報表
- CSV 匯出功能

### 使用者角色

| 角色 | 權限 |
|------|------|
| 系統管理員 (admin) | 所有功能 + 系統設定 |
| 教務承辦 (staff) | 開班、選課、點名、成績管理 |
| 老師 (teacher) | 自己班級的點名、成績輸入 |

### 安裝步驟

#### 1. 環境需求
- Apache/Nginx 網頁伺服器
- PHP 8.1 或以上版本
- MySQL 8.0 或以上版本
- PHP 擴充套件: pdo_mysql, mbstring, json

#### 2. 檔案部署
```bash
# 將 islms 資料夾放置於網站根目錄
cp -r islms /var/www/html/

# 設定資料夾權限
chmod -R 755 /var/www/html/islms
chmod -R 777 /var/www/html/islms/logs
chmod -R 777 /var/www/html/islms/public/uploads
```

#### 3. 資料庫設定
```bash
# 建立資料庫
mysql -u root -p -e "CREATE DATABASE islms CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# 匯入資料表結構
mysql -u root -p islms < islms_schema.sql
```

#### 4. 系統設定
編輯 `config/config.php`：
```php
define('DB_HOST', 'localhost');     // 資料庫主機
define('DB_NAME', 'islms');         // 資料庫名稱
define('DB_USER', 'your_username'); // 資料庫帳號
define('DB_PASS', 'your_password'); // 資料庫密碼
define('APP_URL', 'http://your-domain/islms'); // 系統網址
```

#### 5. 預設帳號
- 帳號: `admin`
- 密碼: `admin123`
- ⚠️ 請登入後立即修改密碼！

### 目錄結構

```
islms/
├── config/          # 設定檔
│   └── config.php
├── core/            # 核心類別
│   ├── Auth.php
│   ├── Controller.php
│   ├── Database.php
│   ├── Helper.php
│   └── Model.php
├── controllers/     # 控制器 (預留)
├── models/          # 資料模型
│   ├── AttendanceModel.php
│   ├── CourseModel.php
│   ├── EnrollmentModel.php
│   ├── GradeModel.php
│   ├── OfferingModel.php
│   ├── SectionModel.php
│   ├── StudentModel.php
│   └── UserModel.php
├── views/           # 視圖模板
│   ├── layouts/
│   ├── auth/
│   ├── dashboard/
│   ├── offerings/
│   ├── sections/
│   ├── attendance/
│   ├── grades/
│   └── reports/
├── public/          # 公開資源
│   ├── css/
│   ├── js/
│   └── uploads/
├── logs/            # 系統日誌
├── index.php        # 入口檔案
├── login.php        # 登入
├── dashboard.php    # 儀表板
├── offerings.php    # 開班管理
├── sections.php     # 班級管理
├── students.php     # 學生管理
├── attendance.php   # 點名管理
├── grades.php       # 成績管理
├── transcripts.php  # 成績單
├── reports.php      # 統計報表
├── users.php        # 帳號管理
├── courses.php      # 課程設定
├── settings.php     # 系統設定
├── profile.php      # 個人資料
└── password.php     # 變更密碼
```

### 程度代碼對照

| 代碼 | 中文名稱 | 英文名稱 |
|------|----------|----------|
| BEG | 入門華語 | Beginner |
| BAS | 基礎華語 | Basic |
| ELE1 | 初級華語一 | Elementary I |
| ELE2 | 初級華語二 | Elementary II |
| INT1 | 中級華語一 | Intermediate I |
| INT2 | 中級華語二 | Intermediate II |
| INT3 | 中級華語三 | Intermediate III |
| ADV1 | 進階華語一 | Advanced I |

### 出席狀態代碼

| 代碼 | 說明 |
|------|------|
| P | 出席 (Present) |
| L | 遲到 (Late) |
| A | 缺席 (Absent) |
| E | 請假 (Excused) |
| O | 公假 (Official Leave) |
| S | 病假 (Sick Leave) |

### 常見問題

**Q: 如何批次匯入學生？**
A: 進入「學生管理」→「匯入」，上傳 Excel 檔案（需包含學號、姓名、Email 等欄位）。

**Q: 如何自動編班？**
A: 在開班詳情頁點擊「自動編班」，系統會依據學生程度自動分配到各班級。

**Q: 點名記錄可以修改嗎？**
A: 可以，但鎖定後需由管理員解鎖才能修改。

**Q: 成績如何計算？**
A: 總分 = Σ(項目分數 × 權重)，等第依總分自動判定 (A:80+, B:70+, C:60+, D:60以下)。

### 版本歷程

- **v1.0.0** (2024) - 初始版本
  - 完整的開班、選課、點名、成績功能
  - 三種使用者角色權限管理
  - 報表匯出功能

### 授權

本系統僅供教學與學術使用。

---

© 2024 國際生學習管理系統
